package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.AdvancementsFix;
import net.minecraft.util.datafix.fixes.AdvancementsRenameFix;
import net.minecraft.util.datafix.fixes.AttributesRename;
import net.minecraft.util.datafix.fixes.BedItemColorFix;
import net.minecraft.util.datafix.fixes.BeehivePoiRenameFix;
import net.minecraft.util.datafix.fixes.BiomeFix;
import net.minecraft.util.datafix.fixes.BitStorageAlignFix;
import net.minecraft.util.datafix.fixes.BlockEntityBannerColorFix;
import net.minecraft.util.datafix.fixes.BlockEntityBlockStateFix;
import net.minecraft.util.datafix.fixes.BlockEntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.BlockEntityIdFix;
import net.minecraft.util.datafix.fixes.BlockEntityJukeboxFix;
import net.minecraft.util.datafix.fixes.BlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.BlockEntityShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignTextStrictJsonFix;
import net.minecraft.util.datafix.fixes.BlockEntityUUIDFix;
import net.minecraft.util.datafix.fixes.BlockNameFlatteningFix;
import net.minecraft.util.datafix.fixes.BlockRenameFix;
import net.minecraft.util.datafix.fixes.BlockRenameFixWithJigsaw;
import net.minecraft.util.datafix.fixes.BlockStateStructureTemplateFix;
import net.minecraft.util.datafix.fixes.CatTypeFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChunkBedBlockEntityInjecterFix;
import net.minecraft.util.datafix.fixes.ChunkBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkLightRemoveFix;
import net.minecraft.util.datafix.fixes.ChunkPalettedStorageFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix2;
import net.minecraft.util.datafix.fixes.ChunkStructuresTemplateRenameFix;
import net.minecraft.util.datafix.fixes.ChunkToProtochunkFix;
import net.minecraft.util.datafix.fixes.ColorlessShulkerEntityFix;
import net.minecraft.util.datafix.fixes.DyeItemRenameFix;
import net.minecraft.util.datafix.fixes.EntityArmorStandSilentFix;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.EntityCatSplitFix;
import net.minecraft.util.datafix.fixes.EntityCodSalmonFix;
import net.minecraft.util.datafix.fixes.EntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.EntityElderGuardianSplitFix;
import net.minecraft.util.datafix.fixes.EntityEquipmentToArmorAndHandFix;
import net.minecraft.util.datafix.fixes.EntityHealthFix;
import net.minecraft.util.datafix.fixes.EntityHorseSaddleFix;
import net.minecraft.util.datafix.fixes.EntityHorseSplitFix;
import net.minecraft.util.datafix.fixes.EntityIdFix;
import net.minecraft.util.datafix.fixes.EntityItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityMinecartIdentifiersFix;
import net.minecraft.util.datafix.fixes.EntityPaintingItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityPaintingMotiveFix;
import net.minecraft.util.datafix.fixes.EntityProjectileOwnerFix;
import net.minecraft.util.datafix.fixes.EntityPufferfishRenameFix;
import net.minecraft.util.datafix.fixes.EntityRavagerRenameFix;
import net.minecraft.util.datafix.fixes.EntityRedundantChanceTagsFix;
import net.minecraft.util.datafix.fixes.EntityRidingToPassengersFix;
import net.minecraft.util.datafix.fixes.EntityShulkerColorFix;
import net.minecraft.util.datafix.fixes.EntityShulkerRotationFix;
import net.minecraft.util.datafix.fixes.EntitySkeletonSplitFix;
import net.minecraft.util.datafix.fixes.EntityStringUuidFix;
import net.minecraft.util.datafix.fixes.EntityTheRenameningFix;
import net.minecraft.util.datafix.fixes.EntityTippedArrowFix;
import net.minecraft.util.datafix.fixes.EntityUUIDFix;
import net.minecraft.util.datafix.fixes.EntityWolfColorFix;
import net.minecraft.util.datafix.fixes.EntityZombieSplitFix;
import net.minecraft.util.datafix.fixes.EntityZombieVillagerTypeFix;
import net.minecraft.util.datafix.fixes.EntityZombifiedPiglinRenameFix;
import net.minecraft.util.datafix.fixes.ForcePoiRebuild;
import net.minecraft.util.datafix.fixes.FurnaceRecipeFix;
import net.minecraft.util.datafix.fixes.GossipUUIDFix;
import net.minecraft.util.datafix.fixes.HeightmapRenamingFix;
import net.minecraft.util.datafix.fixes.IglooMetadataRemovalFix;
import net.minecraft.util.datafix.fixes.ItemBannerColorFix;
import net.minecraft.util.datafix.fixes.ItemCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemLoreFix;
import net.minecraft.util.datafix.fixes.ItemPotionFix;
import net.minecraft.util.datafix.fixes.ItemRenameFix;
import net.minecraft.util.datafix.fixes.ItemShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.ItemSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackEnchantmentNamesFix;
import net.minecraft.util.datafix.fixes.ItemStackMapIdFix;
import net.minecraft.util.datafix.fixes.ItemStackSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.util.datafix.fixes.ItemStackUUIDFix;
import net.minecraft.util.datafix.fixes.ItemWaterPotionFix;
import net.minecraft.util.datafix.fixes.ItemWrittenBookPagesStrictJsonFix;
import net.minecraft.util.datafix.fixes.JigsawPropertiesFix;
import net.minecraft.util.datafix.fixes.JigsawRotationFix;
import net.minecraft.util.datafix.fixes.LeavesFix;
import net.minecraft.util.datafix.fixes.LevelDataGeneratorOptionsFix;
import net.minecraft.util.datafix.fixes.LevelFlatGeneratorInfoFix;
import net.minecraft.util.datafix.fixes.LevelUUIDFix;
import net.minecraft.util.datafix.fixes.MapIdFix;
import net.minecraft.util.datafix.fixes.MemoryExpiryDataFix;
import net.minecraft.util.datafix.fixes.MissingDimensionFix;
import net.minecraft.util.datafix.fixes.MobSpawnerEntityIdentifiersFix;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.NewVillageFix;
import net.minecraft.util.datafix.fixes.ObjectiveDisplayNameFix;
import net.minecraft.util.datafix.fixes.ObjectiveRenderTypeFix;
import net.minecraft.util.datafix.fixes.OminousBannerBlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRenameFix;
import net.minecraft.util.datafix.fixes.OptionsAddTextBackgroundFix;
import net.minecraft.util.datafix.fixes.OptionsForceVBOFix;
import net.minecraft.util.datafix.fixes.OptionsKeyLwjgl3Fix;
import net.minecraft.util.datafix.fixes.OptionsKeyTranslationFix;
import net.minecraft.util.datafix.fixes.OptionsLowerCaseLanguageFix;
import net.minecraft.util.datafix.fixes.OptionsRenameFieldFix;
import net.minecraft.util.datafix.fixes.PlayerUUIDFix;
import net.minecraft.util.datafix.fixes.RecipesFix;
import net.minecraft.util.datafix.fixes.RecipesRenameFix;
import net.minecraft.util.datafix.fixes.RecipesRenameningFix;
import net.minecraft.util.datafix.fixes.RedstoneWireConnectionsFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.fixes.RemoveGolemGossipFix;
import net.minecraft.util.datafix.fixes.RenameBiomesFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFansFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFix;
import net.minecraft.util.datafix.fixes.ReorganizePoi;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.SavedDataUUIDFix;
import net.minecraft.util.datafix.fixes.SavedDataVillageCropFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsCounterFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StriderGravityFix;
import net.minecraft.util.datafix.fixes.StructureReferenceCountFix;
import net.minecraft.util.datafix.fixes.TeamDisplayNameFix;
import net.minecraft.util.datafix.fixes.TrappedChestBlockEntityFix;
import net.minecraft.util.datafix.fixes.VillagerDataFix;
import net.minecraft.util.datafix.fixes.VillagerFollowRangeFix;
import net.minecraft.util.datafix.fixes.VillagerRebuildLevelAndXpFix;
import net.minecraft.util.datafix.fixes.VillagerTradeFix;
import net.minecraft.util.datafix.fixes.WallPropertyFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.WriteAndReadFix;
import net.minecraft.util.datafix.fixes.ZombieVillagerRebuildXpFix;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import net.minecraft.util.datafix.schemas.V100;
import net.minecraft.util.datafix.schemas.V102;
import net.minecraft.util.datafix.schemas.V1022;
import net.minecraft.util.datafix.schemas.V106;
import net.minecraft.util.datafix.schemas.V107;
import net.minecraft.util.datafix.schemas.V1125;
import net.minecraft.util.datafix.schemas.V135;
import net.minecraft.util.datafix.schemas.V143;
import net.minecraft.util.datafix.schemas.V1451;
import net.minecraft.util.datafix.schemas.V1451_1;
import net.minecraft.util.datafix.schemas.V1451_2;
import net.minecraft.util.datafix.schemas.V1451_3;
import net.minecraft.util.datafix.schemas.V1451_4;
import net.minecraft.util.datafix.schemas.V1451_5;
import net.minecraft.util.datafix.schemas.V1451_6;
import net.minecraft.util.datafix.schemas.V1451_7;
import net.minecraft.util.datafix.schemas.V1460;
import net.minecraft.util.datafix.schemas.V1466;
import net.minecraft.util.datafix.schemas.V1470;
import net.minecraft.util.datafix.schemas.V1481;
import net.minecraft.util.datafix.schemas.V1483;
import net.minecraft.util.datafix.schemas.V1486;
import net.minecraft.util.datafix.schemas.V1510;
import net.minecraft.util.datafix.schemas.V1800;
import net.minecraft.util.datafix.schemas.V1801;
import net.minecraft.util.datafix.schemas.V1904;
import net.minecraft.util.datafix.schemas.V1906;
import net.minecraft.util.datafix.schemas.V1909;
import net.minecraft.util.datafix.schemas.V1920;
import net.minecraft.util.datafix.schemas.V1928;
import net.minecraft.util.datafix.schemas.V1929;
import net.minecraft.util.datafix.schemas.V1931;
import net.minecraft.util.datafix.schemas.V2100;
import net.minecraft.util.datafix.schemas.V2501;
import net.minecraft.util.datafix.schemas.V2502;
import net.minecraft.util.datafix.schemas.V2505;
import net.minecraft.util.datafix.schemas.V2509;
import net.minecraft.util.datafix.schemas.V2519;
import net.minecraft.util.datafix.schemas.V2522;
import net.minecraft.util.datafix.schemas.V2551;
import net.minecraft.util.datafix.schemas.V2568;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V501;
import net.minecraft.util.datafix.schemas.V700;
import net.minecraft.util.datafix.schemas.V701;
import net.minecraft.util.datafix.schemas.V702;
import net.minecraft.util.datafix.schemas.V703;
import net.minecraft.util.datafix.schemas.V704;
import net.minecraft.util.datafix.schemas.V705;
import net.minecraft.util.datafix.schemas.V808;
import net.minecraft.util.datafix.schemas.V99;

public class DataFixers {
   private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
   private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = NamespacedSchema::new;
   private static final DataFixer DATA_FIXER = createFixerUpper();

   private static DataFixer createFixerUpper() {
      DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.getCurrentVersion().getWorldVersion());
      addFixers(datafixerbuilder);
      return datafixerbuilder.build(Util.bootstrapExecutor());
   }

   public static DataFixer getDataFixer() {
      return DATA_FIXER;
   }

   private static void addFixers(DataFixerBuilder p_14514_) {
      Schema schema = p_14514_.addSchema(99, V99::new);
      Schema schema1 = p_14514_.addSchema(100, V100::new);
      p_14514_.addFixer(new EntityEquipmentToArmorAndHandFix(schema1, true));
      Schema schema2 = p_14514_.addSchema(101, SAME);
      p_14514_.addFixer(new BlockEntitySignTextStrictJsonFix(schema2, false));
      Schema schema3 = p_14514_.addSchema(102, V102::new);
      p_14514_.addFixer(new ItemIdFix(schema3, true));
      p_14514_.addFixer(new ItemPotionFix(schema3, false));
      Schema schema4 = p_14514_.addSchema(105, SAME);
      p_14514_.addFixer(new ItemSpawnEggFix(schema4, true));
      Schema schema5 = p_14514_.addSchema(106, V106::new);
      p_14514_.addFixer(new MobSpawnerEntityIdentifiersFix(schema5, true));
      Schema schema6 = p_14514_.addSchema(107, V107::new);
      p_14514_.addFixer(new EntityMinecartIdentifiersFix(schema6, true));
      Schema schema7 = p_14514_.addSchema(108, SAME);
      p_14514_.addFixer(new EntityStringUuidFix(schema7, true));
      Schema schema8 = p_14514_.addSchema(109, SAME);
      p_14514_.addFixer(new EntityHealthFix(schema8, true));
      Schema schema9 = p_14514_.addSchema(110, SAME);
      p_14514_.addFixer(new EntityHorseSaddleFix(schema9, true));
      Schema schema10 = p_14514_.addSchema(111, SAME);
      p_14514_.addFixer(new EntityPaintingItemFrameDirectionFix(schema10, true));
      Schema schema11 = p_14514_.addSchema(113, SAME);
      p_14514_.addFixer(new EntityRedundantChanceTagsFix(schema11, true));
      Schema schema12 = p_14514_.addSchema(135, V135::new);
      p_14514_.addFixer(new EntityRidingToPassengersFix(schema12, true));
      Schema schema13 = p_14514_.addSchema(143, V143::new);
      p_14514_.addFixer(new EntityTippedArrowFix(schema13, true));
      Schema schema14 = p_14514_.addSchema(147, SAME);
      p_14514_.addFixer(new EntityArmorStandSilentFix(schema14, true));
      Schema schema15 = p_14514_.addSchema(165, SAME);
      p_14514_.addFixer(new ItemWrittenBookPagesStrictJsonFix(schema15, true));
      Schema schema16 = p_14514_.addSchema(501, V501::new);
      p_14514_.addFixer(new AddNewChoices(schema16, "Add 1.10 entities fix", References.ENTITY));
      Schema schema17 = p_14514_.addSchema(502, SAME);
      p_14514_.addFixer(ItemRenameFix.create(schema17, "cooked_fished item renamer", (p_14533_) -> {
         return Objects.equals(NamespacedSchema.ensureNamespaced(p_14533_), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : p_14533_;
      }));
      p_14514_.addFixer(new EntityZombieVillagerTypeFix(schema17, false));
      Schema schema18 = p_14514_.addSchema(505, SAME);
      p_14514_.addFixer(new OptionsForceVBOFix(schema18, false));
      Schema schema19 = p_14514_.addSchema(700, V700::new);
      p_14514_.addFixer(new EntityElderGuardianSplitFix(schema19, true));
      Schema schema20 = p_14514_.addSchema(701, V701::new);
      p_14514_.addFixer(new EntitySkeletonSplitFix(schema20, true));
      Schema schema21 = p_14514_.addSchema(702, V702::new);
      p_14514_.addFixer(new EntityZombieSplitFix(schema21, true));
      Schema schema22 = p_14514_.addSchema(703, V703::new);
      p_14514_.addFixer(new EntityHorseSplitFix(schema22, true));
      Schema schema23 = p_14514_.addSchema(704, V704::new);
      p_14514_.addFixer(new BlockEntityIdFix(schema23, true));
      Schema schema24 = p_14514_.addSchema(705, V705::new);
      p_14514_.addFixer(new EntityIdFix(schema24, true));
      Schema schema25 = p_14514_.addSchema(804, SAME_NAMESPACED);
      p_14514_.addFixer(new ItemBannerColorFix(schema25, true));
      Schema schema26 = p_14514_.addSchema(806, SAME_NAMESPACED);
      p_14514_.addFixer(new ItemWaterPotionFix(schema26, false));
      Schema schema27 = p_14514_.addSchema(808, V808::new);
      p_14514_.addFixer(new AddNewChoices(schema27, "added shulker box", References.BLOCK_ENTITY));
      Schema schema28 = p_14514_.addSchema(808, 1, SAME_NAMESPACED);
      p_14514_.addFixer(new EntityShulkerColorFix(schema28, false));
      Schema schema29 = p_14514_.addSchema(813, SAME_NAMESPACED);
      p_14514_.addFixer(new ItemShulkerBoxColorFix(schema29, false));
      p_14514_.addFixer(new BlockEntityShulkerBoxColorFix(schema29, false));
      Schema schema30 = p_14514_.addSchema(816, SAME_NAMESPACED);
      p_14514_.addFixer(new OptionsLowerCaseLanguageFix(schema30, false));
      Schema schema31 = p_14514_.addSchema(820, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema31, "totem item renamer", createRenamer("minecraft:totem", "minecraft:totem_of_undying")));
      Schema schema32 = p_14514_.addSchema(1022, V1022::new);
      p_14514_.addFixer(new WriteAndReadFix(schema32, "added shoulder entities to players", References.PLAYER));
      Schema schema33 = p_14514_.addSchema(1125, V1125::new);
      p_14514_.addFixer(new ChunkBedBlockEntityInjecterFix(schema33, true));
      p_14514_.addFixer(new BedItemColorFix(schema33, false));
      Schema schema34 = p_14514_.addSchema(1344, SAME_NAMESPACED);
      p_14514_.addFixer(new OptionsKeyLwjgl3Fix(schema34, false));
      Schema schema35 = p_14514_.addSchema(1446, SAME_NAMESPACED);
      p_14514_.addFixer(new OptionsKeyTranslationFix(schema35, false));
      Schema schema36 = p_14514_.addSchema(1450, SAME_NAMESPACED);
      p_14514_.addFixer(new BlockStateStructureTemplateFix(schema36, false));
      Schema schema37 = p_14514_.addSchema(1451, V1451::new);
      p_14514_.addFixer(new AddNewChoices(schema37, "AddTrappedChestFix", References.BLOCK_ENTITY));
      Schema schema38 = p_14514_.addSchema(1451, 1, V1451_1::new);
      p_14514_.addFixer(new ChunkPalettedStorageFix(schema38, true));
      Schema schema39 = p_14514_.addSchema(1451, 2, V1451_2::new);
      p_14514_.addFixer(new BlockEntityBlockStateFix(schema39, true));
      Schema schema40 = p_14514_.addSchema(1451, 3, V1451_3::new);
      p_14514_.addFixer(new EntityBlockStateFix(schema40, true));
      p_14514_.addFixer(new ItemStackMapIdFix(schema40, false));
      Schema schema41 = p_14514_.addSchema(1451, 4, V1451_4::new);
      p_14514_.addFixer(new BlockNameFlatteningFix(schema41, true));
      p_14514_.addFixer(new ItemStackTheFlatteningFix(schema41, false));
      Schema schema42 = p_14514_.addSchema(1451, 5, V1451_5::new);
      p_14514_.addFixer(new AddNewChoices(schema42, "RemoveNoteBlockFlowerPotFix", References.BLOCK_ENTITY));
      p_14514_.addFixer(new ItemStackSpawnEggFix(schema42, false));
      p_14514_.addFixer(new EntityWolfColorFix(schema42, false));
      p_14514_.addFixer(new BlockEntityBannerColorFix(schema42, false));
      p_14514_.addFixer(new LevelFlatGeneratorInfoFix(schema42, false));
      Schema schema43 = p_14514_.addSchema(1451, 6, V1451_6::new);
      p_14514_.addFixer(new StatsCounterFix(schema43, true));
      p_14514_.addFixer(new WriteAndReadFix(schema43, "Rewrite objectives", References.OBJECTIVE));
      p_14514_.addFixer(new BlockEntityJukeboxFix(schema43, false));
      Schema schema44 = p_14514_.addSchema(1451, 7, V1451_7::new);
      p_14514_.addFixer(new SavedDataVillageCropFix(schema44, true));
      Schema schema45 = p_14514_.addSchema(1451, 7, SAME_NAMESPACED);
      p_14514_.addFixer(new VillagerTradeFix(schema45, false));
      Schema schema46 = p_14514_.addSchema(1456, SAME_NAMESPACED);
      p_14514_.addFixer(new EntityItemFrameDirectionFix(schema46, false));
      Schema schema47 = p_14514_.addSchema(1458, SAME_NAMESPACED);
      p_14514_.addFixer(new EntityCustomNameToComponentFix(schema47, false));
      p_14514_.addFixer(new ItemCustomNameToComponentFix(schema47, false));
      p_14514_.addFixer(new BlockEntityCustomNameToComponentFix(schema47, false));
      Schema schema48 = p_14514_.addSchema(1460, V1460::new);
      p_14514_.addFixer(new EntityPaintingMotiveFix(schema48, false));
      Schema schema49 = p_14514_.addSchema(1466, V1466::new);
      p_14514_.addFixer(new ChunkToProtochunkFix(schema49, true));
      Schema schema50 = p_14514_.addSchema(1470, V1470::new);
      p_14514_.addFixer(new AddNewChoices(schema50, "Add 1.13 entities fix", References.ENTITY));
      Schema schema51 = p_14514_.addSchema(1474, SAME_NAMESPACED);
      p_14514_.addFixer(new ColorlessShulkerEntityFix(schema51, false));
      p_14514_.addFixer(BlockRenameFix.create(schema51, "Colorless shulker block fixer", (p_14531_) -> {
         return Objects.equals(NamespacedSchema.ensureNamespaced(p_14531_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_14531_;
      }));
      p_14514_.addFixer(ItemRenameFix.create(schema51, "Colorless shulker item fixer", (p_14516_) -> {
         return Objects.equals(NamespacedSchema.ensureNamespaced(p_14516_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_14516_;
      }));
      Schema schema52 = p_14514_.addSchema(1475, SAME_NAMESPACED);
      p_14514_.addFixer(BlockRenameFix.create(schema52, "Flowing fixer", createRenamer(ImmutableMap.of("minecraft:flowing_water", "minecraft:water", "minecraft:flowing_lava", "minecraft:lava"))));
      Schema schema53 = p_14514_.addSchema(1480, SAME_NAMESPACED);
      p_14514_.addFixer(BlockRenameFix.create(schema53, "Rename coral blocks", createRenamer(RenamedCoralFix.RENAMED_IDS)));
      p_14514_.addFixer(ItemRenameFix.create(schema53, "Rename coral items", createRenamer(RenamedCoralFix.RENAMED_IDS)));
      Schema schema54 = p_14514_.addSchema(1481, V1481::new);
      p_14514_.addFixer(new AddNewChoices(schema54, "Add conduit", References.BLOCK_ENTITY));
      Schema schema55 = p_14514_.addSchema(1483, V1483::new);
      p_14514_.addFixer(new EntityPufferfishRenameFix(schema55, true));
      p_14514_.addFixer(ItemRenameFix.create(schema55, "Rename pufferfish egg item", createRenamer(EntityPufferfishRenameFix.RENAMED_IDS)));
      Schema schema56 = p_14514_.addSchema(1484, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema56, "Rename seagrass items", createRenamer(ImmutableMap.of("minecraft:sea_grass", "minecraft:seagrass", "minecraft:tall_sea_grass", "minecraft:tall_seagrass"))));
      p_14514_.addFixer(BlockRenameFix.create(schema56, "Rename seagrass blocks", createRenamer(ImmutableMap.of("minecraft:sea_grass", "minecraft:seagrass", "minecraft:tall_sea_grass", "minecraft:tall_seagrass"))));
      p_14514_.addFixer(new HeightmapRenamingFix(schema56, false));
      Schema schema57 = p_14514_.addSchema(1486, V1486::new);
      p_14514_.addFixer(new EntityCodSalmonFix(schema57, true));
      p_14514_.addFixer(ItemRenameFix.create(schema57, "Rename cod/salmon egg items", createRenamer(EntityCodSalmonFix.RENAMED_EGG_IDS)));
      Schema schema58 = p_14514_.addSchema(1487, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema58, "Rename prismarine_brick(s)_* blocks", createRenamer(ImmutableMap.of("minecraft:prismarine_bricks_slab", "minecraft:prismarine_brick_slab", "minecraft:prismarine_bricks_stairs", "minecraft:prismarine_brick_stairs"))));
      p_14514_.addFixer(BlockRenameFix.create(schema58, "Rename prismarine_brick(s)_* items", createRenamer(ImmutableMap.of("minecraft:prismarine_bricks_slab", "minecraft:prismarine_brick_slab", "minecraft:prismarine_bricks_stairs", "minecraft:prismarine_brick_stairs"))));
      Schema schema59 = p_14514_.addSchema(1488, SAME_NAMESPACED);
      p_14514_.addFixer(BlockRenameFix.create(schema59, "Rename kelp/kelptop", createRenamer(ImmutableMap.of("minecraft:kelp_top", "minecraft:kelp", "minecraft:kelp", "minecraft:kelp_plant"))));
      p_14514_.addFixer(ItemRenameFix.create(schema59, "Rename kelptop", createRenamer("minecraft:kelp_top", "minecraft:kelp")));
      p_14514_.addFixer(new NamedEntityFix(schema59, false, "Command block block entity custom name fix", References.BLOCK_ENTITY, "minecraft:command_block") {
         protected Typed<?> fix(Typed<?> p_14541_) {
            return p_14541_.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::fixTagCustomName);
         }
      });
      p_14514_.addFixer(new NamedEntityFix(schema59, false, "Command block minecart custom name fix", References.ENTITY, "minecraft:commandblock_minecart") {
         protected Typed<?> fix(Typed<?> p_14549_) {
            return p_14549_.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::fixTagCustomName);
         }
      });
      p_14514_.addFixer(new IglooMetadataRemovalFix(schema59, false));
      Schema schema60 = p_14514_.addSchema(1490, SAME_NAMESPACED);
      p_14514_.addFixer(BlockRenameFix.create(schema60, "Rename melon_block", createRenamer("minecraft:melon_block", "minecraft:melon")));
      p_14514_.addFixer(ItemRenameFix.create(schema60, "Rename melon_block/melon/speckled_melon", createRenamer(ImmutableMap.of("minecraft:melon_block", "minecraft:melon", "minecraft:melon", "minecraft:melon_slice", "minecraft:speckled_melon", "minecraft:glistering_melon_slice"))));
      Schema schema61 = p_14514_.addSchema(1492, SAME_NAMESPACED);
      p_14514_.addFixer(new ChunkStructuresTemplateRenameFix(schema61, false));
      Schema schema62 = p_14514_.addSchema(1494, SAME_NAMESPACED);
      p_14514_.addFixer(new ItemStackEnchantmentNamesFix(schema62, false));
      Schema schema63 = p_14514_.addSchema(1496, SAME_NAMESPACED);
      p_14514_.addFixer(new LeavesFix(schema63, false));
      Schema schema64 = p_14514_.addSchema(1500, SAME_NAMESPACED);
      p_14514_.addFixer(new BlockEntityKeepPacked(schema64, false));
      Schema schema65 = p_14514_.addSchema(1501, SAME_NAMESPACED);
      p_14514_.addFixer(new AdvancementsFix(schema65, false));
      Schema schema66 = p_14514_.addSchema(1502, SAME_NAMESPACED);
      p_14514_.addFixer(new RecipesFix(schema66, false));
      Schema schema67 = p_14514_.addSchema(1506, SAME_NAMESPACED);
      p_14514_.addFixer(new LevelDataGeneratorOptionsFix(schema67, false));
      Schema schema68 = p_14514_.addSchema(1510, V1510::new);
      p_14514_.addFixer(BlockRenameFix.create(schema68, "Block renamening fix", createRenamer(EntityTheRenameningFix.RENAMED_BLOCKS)));
      p_14514_.addFixer(ItemRenameFix.create(schema68, "Item renamening fix", createRenamer(EntityTheRenameningFix.RENAMED_ITEMS)));
      p_14514_.addFixer(new RecipesRenameningFix(schema68, false));
      p_14514_.addFixer(new EntityTheRenameningFix(schema68, true));
      p_14514_.addFixer(new StatsRenameFix(schema68, "SwimStatsRenameFix", ImmutableMap.of("minecraft:swim_one_cm", "minecraft:walk_on_water_one_cm", "minecraft:dive_one_cm", "minecraft:walk_under_water_one_cm")));
      Schema schema69 = p_14514_.addSchema(1514, SAME_NAMESPACED);
      p_14514_.addFixer(new ObjectiveDisplayNameFix(schema69, false));
      p_14514_.addFixer(new TeamDisplayNameFix(schema69, false));
      p_14514_.addFixer(new ObjectiveRenderTypeFix(schema69, false));
      Schema schema70 = p_14514_.addSchema(1515, SAME_NAMESPACED);
      p_14514_.addFixer(BlockRenameFix.create(schema70, "Rename coral fan blocks", createRenamer(RenamedCoralFansFix.RENAMED_IDS)));
      Schema schema71 = p_14514_.addSchema(1624, SAME_NAMESPACED);
      p_14514_.addFixer(new TrappedChestBlockEntityFix(schema71, false));
      Schema schema72 = p_14514_.addSchema(1800, V1800::new);
      p_14514_.addFixer(new AddNewChoices(schema72, "Added 1.14 mobs fix", References.ENTITY));
      p_14514_.addFixer(ItemRenameFix.create(schema72, "Rename dye items", createRenamer(DyeItemRenameFix.RENAMED_IDS)));
      Schema schema73 = p_14514_.addSchema(1801, V1801::new);
      p_14514_.addFixer(new AddNewChoices(schema73, "Added Illager Beast", References.ENTITY));
      Schema schema74 = p_14514_.addSchema(1802, SAME_NAMESPACED);
      p_14514_.addFixer(BlockRenameFix.create(schema74, "Rename sign blocks & stone slabs", createRenamer(ImmutableMap.of("minecraft:stone_slab", "minecraft:smooth_stone_slab", "minecraft:sign", "minecraft:oak_sign", "minecraft:wall_sign", "minecraft:oak_wall_sign"))));
      p_14514_.addFixer(ItemRenameFix.create(schema74, "Rename sign item & stone slabs", createRenamer(ImmutableMap.of("minecraft:stone_slab", "minecraft:smooth_stone_slab", "minecraft:sign", "minecraft:oak_sign"))));
      Schema schema75 = p_14514_.addSchema(1803, SAME_NAMESPACED);
      p_14514_.addFixer(new ItemLoreFix(schema75, false));
      Schema schema76 = p_14514_.addSchema(1904, V1904::new);
      p_14514_.addFixer(new AddNewChoices(schema76, "Added Cats", References.ENTITY));
      p_14514_.addFixer(new EntityCatSplitFix(schema76, false));
      Schema schema77 = p_14514_.addSchema(1905, SAME_NAMESPACED);
      p_14514_.addFixer(new ChunkStatusFix(schema77, false));
      Schema schema78 = p_14514_.addSchema(1906, V1906::new);
      p_14514_.addFixer(new AddNewChoices(schema78, "Add POI Blocks", References.BLOCK_ENTITY));
      Schema schema79 = p_14514_.addSchema(1909, V1909::new);
      p_14514_.addFixer(new AddNewChoices(schema79, "Add jigsaw", References.BLOCK_ENTITY));
      Schema schema80 = p_14514_.addSchema(1911, SAME_NAMESPACED);
      p_14514_.addFixer(new ChunkStatusFix2(schema80, false));
      Schema schema81 = p_14514_.addSchema(1917, SAME_NAMESPACED);
      p_14514_.addFixer(new CatTypeFix(schema81, false));
      Schema schema82 = p_14514_.addSchema(1918, SAME_NAMESPACED);
      p_14514_.addFixer(new VillagerDataFix(schema82, "minecraft:villager"));
      p_14514_.addFixer(new VillagerDataFix(schema82, "minecraft:zombie_villager"));
      Schema schema83 = p_14514_.addSchema(1920, V1920::new);
      p_14514_.addFixer(new NewVillageFix(schema83, false));
      p_14514_.addFixer(new AddNewChoices(schema83, "Add campfire", References.BLOCK_ENTITY));
      Schema schema84 = p_14514_.addSchema(1925, SAME_NAMESPACED);
      p_14514_.addFixer(new MapIdFix(schema84, false));
      Schema schema85 = p_14514_.addSchema(1928, V1928::new);
      p_14514_.addFixer(new EntityRavagerRenameFix(schema85, true));
      p_14514_.addFixer(ItemRenameFix.create(schema85, "Rename ravager egg item", createRenamer(EntityRavagerRenameFix.RENAMED_IDS)));
      Schema schema86 = p_14514_.addSchema(1929, V1929::new);
      p_14514_.addFixer(new AddNewChoices(schema86, "Add Wandering Trader and Trader Llama", References.ENTITY));
      Schema schema87 = p_14514_.addSchema(1931, V1931::new);
      p_14514_.addFixer(new AddNewChoices(schema87, "Added Fox", References.ENTITY));
      Schema schema88 = p_14514_.addSchema(1936, SAME_NAMESPACED);
      p_14514_.addFixer(new OptionsAddTextBackgroundFix(schema88, false));
      Schema schema89 = p_14514_.addSchema(1946, SAME_NAMESPACED);
      p_14514_.addFixer(new ReorganizePoi(schema89, false));
      Schema schema90 = p_14514_.addSchema(1948, SAME_NAMESPACED);
      p_14514_.addFixer(new OminousBannerRenameFix(schema90, false));
      Schema schema91 = p_14514_.addSchema(1953, SAME_NAMESPACED);
      p_14514_.addFixer(new OminousBannerBlockEntityRenameFix(schema91, false));
      Schema schema92 = p_14514_.addSchema(1955, SAME_NAMESPACED);
      p_14514_.addFixer(new VillagerRebuildLevelAndXpFix(schema92, false));
      p_14514_.addFixer(new ZombieVillagerRebuildXpFix(schema92, false));
      Schema schema93 = p_14514_.addSchema(1961, SAME_NAMESPACED);
      p_14514_.addFixer(new ChunkLightRemoveFix(schema93, false));
      Schema schema94 = p_14514_.addSchema(1963, SAME_NAMESPACED);
      p_14514_.addFixer(new RemoveGolemGossipFix(schema94, false));
      Schema schema95 = p_14514_.addSchema(2100, V2100::new);
      p_14514_.addFixer(new AddNewChoices(schema95, "Added Bee and Bee Stinger", References.ENTITY));
      p_14514_.addFixer(new AddNewChoices(schema95, "Add beehive", References.BLOCK_ENTITY));
      p_14514_.addFixer(new RecipesRenameFix(schema95, false, "Rename sugar recipe", createRenamer("minecraft:sugar", "sugar_from_sugar_cane")));
      p_14514_.addFixer(new AdvancementsRenameFix(schema95, false, "Rename sugar recipe advancement", createRenamer("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
      Schema schema96 = p_14514_.addSchema(2202, SAME_NAMESPACED);
      p_14514_.addFixer(new ChunkBiomeFix(schema96, false));
      Schema schema97 = p_14514_.addSchema(2209, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema97, "Rename bee_hive item to beehive", createRenamer("minecraft:bee_hive", "minecraft:beehive")));
      p_14514_.addFixer(new BeehivePoiRenameFix(schema97));
      p_14514_.addFixer(BlockRenameFix.create(schema97, "Rename bee_hive block to beehive", createRenamer("minecraft:bee_hive", "minecraft:beehive")));
      Schema schema98 = p_14514_.addSchema(2211, SAME_NAMESPACED);
      p_14514_.addFixer(new StructureReferenceCountFix(schema98, false));
      Schema schema99 = p_14514_.addSchema(2218, SAME_NAMESPACED);
      p_14514_.addFixer(new ForcePoiRebuild(schema99, false));
      Schema schema100 = p_14514_.addSchema(2501, V2501::new);
      p_14514_.addFixer(new FurnaceRecipeFix(schema100, true));
      Schema schema101 = p_14514_.addSchema(2502, V2502::new);
      p_14514_.addFixer(new AddNewChoices(schema101, "Added Hoglin", References.ENTITY));
      Schema schema102 = p_14514_.addSchema(2503, SAME_NAMESPACED);
      p_14514_.addFixer(new WallPropertyFix(schema102, false));
      p_14514_.addFixer(new AdvancementsRenameFix(schema102, false, "Composter category change", createRenamer("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
      Schema schema103 = p_14514_.addSchema(2505, V2505::new);
      p_14514_.addFixer(new AddNewChoices(schema103, "Added Piglin", References.ENTITY));
      p_14514_.addFixer(new MemoryExpiryDataFix(schema103, "minecraft:villager"));
      Schema schema104 = p_14514_.addSchema(2508, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema104, "Renamed fungi items to fungus", createRenamer(ImmutableMap.of("minecraft:warped_fungi", "minecraft:warped_fungus", "minecraft:crimson_fungi", "minecraft:crimson_fungus"))));
      p_14514_.addFixer(BlockRenameFix.create(schema104, "Renamed fungi blocks to fungus", createRenamer(ImmutableMap.of("minecraft:warped_fungi", "minecraft:warped_fungus", "minecraft:crimson_fungi", "minecraft:crimson_fungus"))));
      Schema schema105 = p_14514_.addSchema(2509, V2509::new);
      p_14514_.addFixer(new EntityZombifiedPiglinRenameFix(schema105));
      p_14514_.addFixer(ItemRenameFix.create(schema105, "Rename zombie pigman egg item", createRenamer(EntityZombifiedPiglinRenameFix.RENAMED_IDS)));
      Schema schema106 = p_14514_.addSchema(2511, SAME_NAMESPACED);
      p_14514_.addFixer(new EntityProjectileOwnerFix(schema106));
      Schema schema107 = p_14514_.addSchema(2514, SAME_NAMESPACED);
      p_14514_.addFixer(new EntityUUIDFix(schema107));
      p_14514_.addFixer(new BlockEntityUUIDFix(schema107));
      p_14514_.addFixer(new PlayerUUIDFix(schema107));
      p_14514_.addFixer(new LevelUUIDFix(schema107));
      p_14514_.addFixer(new SavedDataUUIDFix(schema107));
      p_14514_.addFixer(new ItemStackUUIDFix(schema107));
      Schema schema108 = p_14514_.addSchema(2516, SAME_NAMESPACED);
      p_14514_.addFixer(new GossipUUIDFix(schema108, "minecraft:villager"));
      p_14514_.addFixer(new GossipUUIDFix(schema108, "minecraft:zombie_villager"));
      Schema schema109 = p_14514_.addSchema(2518, SAME_NAMESPACED);
      p_14514_.addFixer(new JigsawPropertiesFix(schema109, false));
      p_14514_.addFixer(new JigsawRotationFix(schema109, false));
      Schema schema110 = p_14514_.addSchema(2519, V2519::new);
      p_14514_.addFixer(new AddNewChoices(schema110, "Added Strider", References.ENTITY));
      Schema schema111 = p_14514_.addSchema(2522, V2522::new);
      p_14514_.addFixer(new AddNewChoices(schema111, "Added Zoglin", References.ENTITY));
      Schema schema112 = p_14514_.addSchema(2523, SAME_NAMESPACED);
      p_14514_.addFixer(new AttributesRename(schema112));
      Schema schema113 = p_14514_.addSchema(2527, SAME_NAMESPACED);
      p_14514_.addFixer(new BitStorageAlignFix(schema113));
      Schema schema114 = p_14514_.addSchema(2528, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema114, "Rename soul fire torch and soul fire lantern", createRenamer(ImmutableMap.of("minecraft:soul_fire_torch", "minecraft:soul_torch", "minecraft:soul_fire_lantern", "minecraft:soul_lantern"))));
      p_14514_.addFixer(BlockRenameFix.create(schema114, "Rename soul fire torch and soul fire lantern", createRenamer(ImmutableMap.of("minecraft:soul_fire_torch", "minecraft:soul_torch", "minecraft:soul_fire_wall_torch", "minecraft:soul_wall_torch", "minecraft:soul_fire_lantern", "minecraft:soul_lantern"))));
      Schema schema115 = p_14514_.addSchema(2529, SAME_NAMESPACED);
      p_14514_.addFixer(new StriderGravityFix(schema115, false));
      Schema schema116 = p_14514_.addSchema(2531, SAME_NAMESPACED);
      p_14514_.addFixer(new RedstoneWireConnectionsFix(schema116));
      Schema schema117 = p_14514_.addSchema(2533, SAME_NAMESPACED);
      p_14514_.addFixer(new VillagerFollowRangeFix(schema117));
      Schema schema118 = p_14514_.addSchema(2535, SAME_NAMESPACED);
      p_14514_.addFixer(new EntityShulkerRotationFix(schema118));
      Schema schema119 = p_14514_.addSchema(2550, SAME_NAMESPACED);
      p_14514_.addFixer(new WorldGenSettingsFix(schema119));
      Schema schema120 = p_14514_.addSchema(2551, V2551::new);
      p_14514_.addFixer(new WriteAndReadFix(schema120, "add types to WorldGenData", References.WORLD_GEN_SETTINGS));
      Schema schema121 = p_14514_.addSchema(2552, SAME_NAMESPACED);
      p_14514_.addFixer(new RenameBiomesFix(schema121, false, "Nether biome rename", ImmutableMap.of("minecraft:nether", "minecraft:nether_wastes")));
      Schema schema122 = p_14514_.addSchema(2553, SAME_NAMESPACED);
      p_14514_.addFixer(new BiomeFix(schema122, false));
      Schema schema123 = p_14514_.addSchema(2558, SAME_NAMESPACED);
      p_14514_.addFixer(new MissingDimensionFix(schema123, false));
      p_14514_.addFixer(new OptionsRenameFieldFix(schema123, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
      Schema schema124 = p_14514_.addSchema(2568, V2568::new);
      p_14514_.addFixer(new AddNewChoices(schema124, "Added Piglin Brute", References.ENTITY));
      Schema schema125 = p_14514_.addSchema(2571, V2571::new);
      p_14514_.addFixer(new AddNewChoices(schema125, "Added Goat", References.ENTITY));
      Schema schema126 = p_14514_.addSchema(2679, SAME_NAMESPACED);
      p_14514_.addFixer(new CauldronRenameFix(schema126, false));
      Schema schema127 = p_14514_.addSchema(2680, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema127, "Renamed grass path item to dirt path", createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
      p_14514_.addFixer(BlockRenameFixWithJigsaw.create(schema127, "Renamed grass path block to dirt path", createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
      Schema schema128 = p_14514_.addSchema(2684, V2684::new);
      p_14514_.addFixer(new AddNewChoices(schema128, "Added Sculk Sensor", References.BLOCK_ENTITY));
      Schema schema129 = p_14514_.addSchema(2686, V2686::new);
      p_14514_.addFixer(new AddNewChoices(schema129, "Added Axolotl", References.ENTITY));
      Schema schema130 = p_14514_.addSchema(2688, V2688::new);
      p_14514_.addFixer(new AddNewChoices(schema130, "Added Glow Squid", References.ENTITY));
      p_14514_.addFixer(new AddNewChoices(schema130, "Added Glow Item Frame", References.ENTITY));
      Schema schema131 = p_14514_.addSchema(2690, SAME_NAMESPACED);
      ImmutableMap<String, String> immutablemap = ImmutableMap.<String, String>builder().put("minecraft:weathered_copper_block", "minecraft:oxidized_copper_block").put("minecraft:semi_weathered_copper_block", "minecraft:weathered_copper_block").put("minecraft:lightly_weathered_copper_block", "minecraft:exposed_copper_block").put("minecraft:weathered_cut_copper", "minecraft:oxidized_cut_copper").put("minecraft:semi_weathered_cut_copper", "minecraft:weathered_cut_copper").put("minecraft:lightly_weathered_cut_copper", "minecraft:exposed_cut_copper").put("minecraft:weathered_cut_copper_stairs", "minecraft:oxidized_cut_copper_stairs").put("minecraft:semi_weathered_cut_copper_stairs", "minecraft:weathered_cut_copper_stairs").put("minecraft:lightly_weathered_cut_copper_stairs", "minecraft:exposed_cut_copper_stairs").put("minecraft:weathered_cut_copper_slab", "minecraft:oxidized_cut_copper_slab").put("minecraft:semi_weathered_cut_copper_slab", "minecraft:weathered_cut_copper_slab").put("minecraft:lightly_weathered_cut_copper_slab", "minecraft:exposed_cut_copper_slab").put("minecraft:waxed_semi_weathered_copper", "minecraft:waxed_weathered_copper").put("minecraft:waxed_lightly_weathered_copper", "minecraft:waxed_exposed_copper").put("minecraft:waxed_semi_weathered_cut_copper", "minecraft:waxed_weathered_cut_copper").put("minecraft:waxed_lightly_weathered_cut_copper", "minecraft:waxed_exposed_cut_copper").put("minecraft:waxed_semi_weathered_cut_copper_stairs", "minecraft:waxed_weathered_cut_copper_stairs").put("minecraft:waxed_lightly_weathered_cut_copper_stairs", "minecraft:waxed_exposed_cut_copper_stairs").put("minecraft:waxed_semi_weathered_cut_copper_slab", "minecraft:waxed_weathered_cut_copper_slab").put("minecraft:waxed_lightly_weathered_cut_copper_slab", "minecraft:waxed_exposed_cut_copper_slab").build();
      p_14514_.addFixer(ItemRenameFix.create(schema131, "Renamed copper block items to new oxidized terms", createRenamer(immutablemap)));
      p_14514_.addFixer(BlockRenameFixWithJigsaw.create(schema131, "Renamed copper blocks to new oxidized terms", createRenamer(immutablemap)));
      Schema schema132 = p_14514_.addSchema(2691, SAME_NAMESPACED);
      ImmutableMap<String, String> immutablemap1 = ImmutableMap.<String, String>builder().put("minecraft:waxed_copper", "minecraft:waxed_copper_block").put("minecraft:oxidized_copper_block", "minecraft:oxidized_copper").put("minecraft:weathered_copper_block", "minecraft:weathered_copper").put("minecraft:exposed_copper_block", "minecraft:exposed_copper").build();
      p_14514_.addFixer(ItemRenameFix.create(schema132, "Rename copper item suffixes", createRenamer(immutablemap1)));
      p_14514_.addFixer(BlockRenameFixWithJigsaw.create(schema132, "Rename copper blocks suffixes", createRenamer(immutablemap1)));
      Schema schema133 = p_14514_.addSchema(2693, SAME_NAMESPACED);
      p_14514_.addFixer(new AddFlagIfNotPresentFix(schema133, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
      Schema schema134 = p_14514_.addSchema(2696, SAME_NAMESPACED);
      ImmutableMap<String, String> immutablemap2 = ImmutableMap.<String, String>builder().put("minecraft:grimstone", "minecraft:deepslate").put("minecraft:grimstone_slab", "minecraft:cobbled_deepslate_slab").put("minecraft:grimstone_stairs", "minecraft:cobbled_deepslate_stairs").put("minecraft:grimstone_wall", "minecraft:cobbled_deepslate_wall").put("minecraft:polished_grimstone", "minecraft:polished_deepslate").put("minecraft:polished_grimstone_slab", "minecraft:polished_deepslate_slab").put("minecraft:polished_grimstone_stairs", "minecraft:polished_deepslate_stairs").put("minecraft:polished_grimstone_wall", "minecraft:polished_deepslate_wall").put("minecraft:grimstone_tiles", "minecraft:deepslate_tiles").put("minecraft:grimstone_tile_slab", "minecraft:deepslate_tile_slab").put("minecraft:grimstone_tile_stairs", "minecraft:deepslate_tile_stairs").put("minecraft:grimstone_tile_wall", "minecraft:deepslate_tile_wall").put("minecraft:grimstone_bricks", "minecraft:deepslate_bricks").put("minecraft:grimstone_brick_slab", "minecraft:deepslate_brick_slab").put("minecraft:grimstone_brick_stairs", "minecraft:deepslate_brick_stairs").put("minecraft:grimstone_brick_wall", "minecraft:deepslate_brick_wall").put("minecraft:chiseled_grimstone", "minecraft:chiseled_deepslate").build();
      p_14514_.addFixer(ItemRenameFix.create(schema134, "Renamed grimstone block items to deepslate", createRenamer(immutablemap2)));
      p_14514_.addFixer(BlockRenameFixWithJigsaw.create(schema134, "Renamed grimstone blocks to deepslate", createRenamer(immutablemap2)));
      Schema schema135 = p_14514_.addSchema(2700, SAME_NAMESPACED);
      p_14514_.addFixer(BlockRenameFixWithJigsaw.create(schema135, "Renamed cave vines blocks", createRenamer(ImmutableMap.of("minecraft:cave_vines_head", "minecraft:cave_vines", "minecraft:cave_vines_body", "minecraft:cave_vines_plant"))));
      Schema schema136 = p_14514_.addSchema(2701, SAME_NAMESPACED);
      p_14514_.addFixer(new SavedDataFeaturePoolElementFix(schema136));
      Schema schema137 = p_14514_.addSchema(2702, SAME_NAMESPACED);
      p_14514_.addFixer(new AbstractArrowPickupFix(schema137));
      Schema schema138 = p_14514_.addSchema(2704, V2704::new);
      p_14514_.addFixer(new AddNewChoices(schema138, "Added Goat", References.ENTITY));
      Schema schema139 = p_14514_.addSchema(2707, V2707::new);
      p_14514_.addFixer(new AddNewChoices(schema139, "Added Marker", References.ENTITY));
      p_14514_.addFixer(new AddFlagIfNotPresentFix(schema139, References.WORLD_GEN_SETTINGS, "has_increased_height_already", true));
      Schema schema140 = p_14514_.addSchema(2710, SAME_NAMESPACED);
      p_14514_.addFixer(new StatsRenameFix(schema140, "Renamed play_one_minute stat to play_time", ImmutableMap.of("minecraft:play_one_minute", "minecraft:play_time")));
      Schema schema141 = p_14514_.addSchema(2717, SAME_NAMESPACED);
      p_14514_.addFixer(ItemRenameFix.create(schema141, "Rename azalea_leaves_flowers", createRenamer(ImmutableMap.of("minecraft:azalea_leaves_flowers", "minecraft:flowering_azalea_leaves"))));
      p_14514_.addFixer(BlockRenameFix.create(schema141, "Rename azalea_leaves_flowers items", createRenamer(ImmutableMap.of("minecraft:azalea_leaves_flowers", "minecraft:flowering_azalea_leaves"))));
      Schema schema142 = p_14514_.addSchema(2825, SAME_NAMESPACED);
      p_14514_.addFixer(new AddFlagIfNotPresentFix(schema142, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
      Schema schema143 = p_14514_.addSchema(2831, V2831::new);
      p_14514_.addFixer(new SpawnerDataFix(schema143));
      Schema schema144 = p_14514_.addSchema(2832, V2832::new);
      p_14514_.addFixer(new WorldGenSettingsHeightAndBiomeFix(schema144));
      p_14514_.addFixer(new ChunkHeightAndBiomeFix(schema144));
      Schema schema145 = p_14514_.addSchema(2833, SAME_NAMESPACED);
      p_14514_.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema145));
      Schema schema146 = p_14514_.addSchema(2838, SAME_NAMESPACED);
      p_14514_.addFixer(new RenameBiomesFix(schema146, false, "Caves and Cliffs biome renames", CavesAndCliffsRenames.RENAMES));
      Schema schema147 = p_14514_.addSchema(2841, SAME_NAMESPACED);
      p_14514_.addFixer(new ChunkProtoTickListFix(schema147));
      Schema schema148 = p_14514_.addSchema(2842, V2842::new);
      p_14514_.addFixer(new ChunkRenamesFix(schema148));
      Schema schema149 = p_14514_.addSchema(2843, SAME_NAMESPACED);
      p_14514_.addFixer(new RenameBiomesFix(schema149, false, "Remove Deep Warm Ocean", Map.of("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
      Schema schema150 = p_14514_.addSchema(2846, SAME_NAMESPACED);
      p_14514_.addFixer(new AdvancementsRenameFix(schema150, false, "Rename some C&C part 2 advancements", createRenamer(ImmutableMap.of("minecraft:husbandry/play_jukebox_in_meadows", "minecraft:adventure/play_jukebox_in_meadows", "minecraft:adventure/caves_and_cliff", "minecraft:adventure/fall_from_world_height", "minecraft:adventure/ride_strider_in_overworld_lava", "minecraft:nether/ride_strider_in_overworld_lava"))));
      Schema schema151 = p_14514_.addSchema(2852, SAME_NAMESPACED);
      p_14514_.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema151));
   }

   private static UnaryOperator<String> createRenamer(Map<String, String> p_14525_) {
      return (p_14528_) -> {
         return p_14525_.getOrDefault(p_14528_, p_14528_);
      };
   }

   private static UnaryOperator<String> createRenamer(String p_14518_, String p_14519_) {
      return (p_14523_) -> {
         return Objects.equals(p_14523_, p_14518_) ? p_14519_ : p_14523_;
      };
   }
}