package com.idtech.item;
import com.idtech.BaseMod;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.*;

import javax.annotation.Nullable;
public class CursedArmorItem extends ArmorItem {
    private static Properties properties=new Properties().tab(CreativeModeTab.TAB_MISC);
    private static ArmorMaterial customMaterial=ArmorMaterials.NETHERITE;

    public static final Item HELM = new CursedArmorItem(customMaterial, EquipmentSlot.HEAD, (properties)).setRegistryName(BaseMod.MODID, "cursedhelmet");
    public static final Item CHEST = new CursedArmorItem(customMaterial, EquipmentSlot.CHEST, (properties)).setRegistryName(BaseMod.MODID, "cursedchestplate");
    public static final Item FEET = new CursedArmorItem(customMaterial, EquipmentSlot.FEET, (properties)).setRegistryName(BaseMod.MODID, "cursedtoesies");
public static final Item LEGS = new CursedArmorItem(customMaterial, EquipmentSlot.LEGS, (properties)).setRegistryName(BaseMod.MODID, "cursedpantalones");
    public CursedArmorItem(ArmorMaterial material, EquipmentSlot slot, Properties properties) {
        super(material, slot, properties);
    }

    @Nullable @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {

        if(slot == EquipmentSlot.LEGS) {
            return "examplemod:textures/models/armor/cursed_armor_layer_2.png";
        }else{
            return "examplemod:textures/models/armor/cursed_armor_layer_1.png";
        }
    }
}
