# Contributing

You are welcome to contribute to the project. We use Grunt for building the website and jest for testing.


## Help wanted

While you can open an issue for other reasons, these are the main areas where help is most needed:

- Documentation. Writing new areas ([open an issue first](#pull-requests)), improving the grammar/typos/etc. Also, adding many examples, which should be tested first; a good place would be in `/examples`.

- Testing. In many situations we are testing the *happy path* only, so we'd need more tests for others.

- Errors. This project has an unusual section called errors where all of the errors are logged. Wording/improving these is very welcome.

- Examples. Some simple examples in the folder `/examples` help newcomers and can be included later on in the documentation. The reverse is also true, you can test an example from the documentation in this folder.



## Pull Requests

Before opening any PR with new functionality or change a section of the web or documentation please open an issue to discuss it first.

> Tiny PR fixing typos, some wording, a website issue, etc are perfectly okay and promptly accepted.

**Small PR are preferred** than large ones. If in doubt, open an issue, [ask me personally](http://francisco.io/) or make it small. Since this is mostly a 1-person project, large PR will probably sit idle for a while or flatly rejected (related: [you can also donate or sponsor the project](https://serverjs.io/sponsor) so I'll be able to invest more time and resources on it).



## Security issues

Please do not open any vulnerability issue on Github's issue tracker. Send me an email (find my personal email in [my website](http://francisco.io/)) if you find a particular issue within server, or contact privately the package author in case it's a sub-package issue.

I do not have a PGP-based email right now, but if requested I'll make sure to find out how to use it and publish it in [github](https://github.com/franciscop) or [twitter](http://twitter.com/fpresencia).
